/**
* \file: AilAudioSource.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
*          J. Michalik / ADITG/SW1 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "AilAudioSource.h"
#include "AilAudioSourceImpl.h"

namespace adit { namespace aauto {

AilAudioSource::AilAudioSource(uint8_t inSessionId, MessageRouter* inMessageRouter,
        int inCodec) :
                AditAudioSource(inSessionId, inMessageRouter, inCodec)
{
    impl = new AilAudioSourceImpl(this);
}

AilAudioSource::~AilAudioSource()
{
    /* This impl pointer is deleted at shared_ptr in callbak impl on GalReceiver */
}

bool AilAudioSource::init()
{
    return impl->init();
}
void AilAudioSource::shutdown()
{
    impl->shutdown();
}
void AilAudioSource::setConfigItem(string inKey, string inValue)
{
    return impl->setConfigItem(inKey, inValue);
}

void AilAudioSource::registerCallbacks(IAditAudioSourceCallbacks* inCallbacks)
{
    return impl->registerCallbacks(inCallbacks);
}

} } // namespace adit { namespace aauto {
